/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2025 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#ifndef COUPONPRINTER_H
#define COUPONPRINTER_H

#include <QDialog>
#include <QGraphicsTextItem>

class QPrinter;
class QGridLayout;
class QCheckBox;
class QGroupBox;
class QSpinBox;
class QHBoxLayout;

class CouponPrinter : public QDialog {
    Q_OBJECT

public:
    CouponPrinter(const QString &voucherCode, const QString &infoText, QWidget *parent = nullptr);
    ~CouponPrinter();

private slots:
    void toggleInfoText();
    void updatePreview();
    void updateBarcodeSize(int size);
    void updateFontSize(int size, QGraphicsTextItem *textItem);
    void showPrintPreview();
    void directPrint();
    void toggleExtendedSettings();
    void selectTemplate();
    void loadDefaultTemplate();

private:
    void addSetting(const QString &labelText, QSpinBox **spinBox, QGridLayout *layout, int row, int column = 0,
        bool hidden = false);
    void addSettingPair(const QString &label1, const QString &label2, QSpinBox **spinBox1, QSpinBox **spinBox2,
        QGridLayout *layout, int row, bool hidden = false);
    void addButtonToLayout(
        const QString &buttonText, const QString &iconPath, QHBoxLayout *layout, void (CouponPrinter::*function)());
    void adjustWindowSize(const QSize &size);
    QImage createDefaultTemplate();
    QImage generateBarcodeImage(const QString &barcodeText, int size);
    void loadSettings();
    void saveSettings();
    void printVoucher(QPrinter *printer);
    void quit();

    QString m_voucherCode;
    QString m_infoText;

    QGraphicsScene *graphicsScene;
    QGraphicsPixmapItem *templatePixmapItem;
    QGraphicsTextItem *codeTextItem;
    QGraphicsTextItem *textItem;
    QGraphicsPixmapItem *barcodePixmapItem;

    QImage templateImage;
    QString templateImagePath;
    QImage barcodeImage;

    QCheckBox *showInfoTextCheckBox;
    QCheckBox *extendCheckBox;
    QGroupBox *settingsGroup;

    QSpinBox *xSpinBox;
    QSpinBox *ySpinBox;
    QSpinBox *barcodeXSpinBox;
    QSpinBox *barcodeYSpinBox;
    QSpinBox *textXSpinBox;
    QSpinBox *textYSpinBox;
    QSpinBox *templateXSpinBox;
    QSpinBox *templateYSpinBox;
    QSpinBox *barcodeSizeSpinBox;
    QSpinBox *textSizeSpinBox;
    QSpinBox *codeSizeSpinBox;


    bool extendedSettingsVisible;
};

#endif // COUPONPRINTER_H
