/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2025 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#ifndef MAINWIDGET_H
#define MAINWIDGET_H

#include <QDate>
#include <QJsonObject>
#include <QMainWindow>
#include <QUdpSocket>

class QRKHome;
class QRKDocument;
class QRKRegister;
#if defined(QRK_GASTRO)
class QRKGastro;
#endif
class QStackedWidget;
class QLCDNumber;
class QLabel;
class QProgressBar;
class VersionChecker;
class WaiterLock;
class QrkUserLogin;

namespace Ui {
class MainWindow;
}

class QRK : public QMainWindow {
    Q_OBJECT

public:
    QRK(bool importmode = false, QWidget *parent = Q_NULLPTR);
    ~QRK();

    void setShopName();
    int getCurrentRegisterYear()
    {
        return m_currentRegisterYear;
    }
    void setResuscitationCashRegister(bool visible);
    void closeCashRegister();
    void logOnOff(bool);

    QLabel *m_currentRegisterYearLabel;
    QLabel *m_cashRegisterIdLabel;

protected:
    void iniStack();

signals:
    void setImportMode(bool);
    void waiterLockAccept(bool);
    void needToShow();

private slots:
    void endOfDaySlot();
    void endOfMonthSlot();
    void onRegisterButton_clicked();
    void onCancelRegisterButton_clicked();
    void userChanged();
    bool ignoreOpenTickets();
#if not defined(QRK_GASTRO)
    void finishedReceipt();
#endif
    void onManagerButton_clicked();
    void init();
    void initPlugins();

    void onDocumentButton_clicked();
    void onCancelDocumentButton_clicked();
    void import_CSV();
    void export_CSV();
    void export_JSON();
    void exportProducts_CSV();
    void infoFON();
    void backupDEP();
    void backup();
    void runPlugin();
    void viewPlugins();

    void setSafetyDevice(bool active);
    void updateRKStatus();

    void actionAclManager();
    void actionAbout_QRK();
    void actionQRK_Forum();
    void actionQRKLogUpload();
    void actionLeaveDemoMode();
    void actionResetDemoData();
    void actionResuscitationCashRegister();

    void fullScreenSlot();
    void setFullScreenMode(bool);
    void waitForThreadsWithTimeout(int timeout = 30000);
    void exitSlot();
    void restore();
    void newApplicationVersionAvailable(QJsonObject jsondata);
    void sendDatagram(QString what, QString data);
    void handleMessage(const QString &message);

protected slots:
    virtual void timerDone();

public slots:
    void setStatusBarProgressBar(int value, bool add);
    void setStatusBarProgressBarWait(bool on_off);
    void waiterLockRequest(QString data);

private:
    void DateTimeCheck();
    void closeEvent(QCloseEvent *event);
    Ui::MainWindow *ui;

    bool m_importmode;
    QString shopname();
    QLCDNumber *m_dateLcd;

    void startACS();
    void restartApplication();

    QLabel *m_dep;
    QLabel *m_depPX;
    QLabel *m_safetyDevicePX;

    QProgressBar *m_progressBar;

    QRKHome *m_qrk_home;
    QRKDocument *m_qrk_document;
#if defined(QRK_GASTRO)
    QRKGastro *m_qrk_gastro = Q_NULLPTR;
#else
    QRKRegister *m_qrk_register = Q_NULLPTR;
#endif
    QStackedWidget *m_stackedWidget;
    QTimer *m_timer;
    QDateTime m_checkDateTime;

    int m_currentRegisterYear;
    QString m_cashRegisterId;

    QString m_shopName;
    bool m_previousSafetyDeviceState;
    bool m_insideLogin = false;
    bool m_forceexit = false;
    QThread *m_checkerThread = Q_NULLPTR;
    QThread *m_acsThread = Q_NULLPTR;
    VersionChecker *m_versionChecker = Q_NULLPTR;
    QUdpSocket udpSocket;
    WaiterLock *m_waiterLock = Q_NULLPTR;
    QrkUserLogin *m_login = Q_NULLPTR;
};

#endif // MAINWIDGET_H
