/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2025 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#include "aboutdlg.h"
#include "3rdparty/ckvsoft/uniquemachinefingerprint.h"
#include "3rdparty/ckvsoft/version.h"
#include "ui_aboutdlg.h"

#include <QFile>
#include <QScrollBar>
#include <QTextStream>

AboutDlg::AboutDlg(QWidget *parent)
    : QDialog(parent)
    , ui(new Ui::AboutDlg)
{
    ui->setupUi(this);
    readLicense();
    ui->serialLabel->setText(tr("Seriennummer: %1)").arg(getSerialNumber()));
    ui->versionLabel->setText(tr("Version: %1\n%2: %3")
            .arg(qApp->applicationVersion())
            .arg("ckvsoft")
            .arg(CKVersion::getNiceVersionNumber()));
}

AboutDlg::~AboutDlg()
{
    // no need to delete child widgets, Qt does it all for us
}

QString AboutDlg::getSerialNumber()
{
    UniqueMachineFingerprint uf;
    return uf.getSystemUniqueId();
}

void AboutDlg::readLicense()
{
    QFile file;
    file.setFileName(":/src/txt/gpl-3.0." + QLocale::system().name() + ".txt");
    if (!file.exists()) file.setFileName(":/src/txt/gpl-3.0.txt");

    ui->textBrowser->clear();
    if (file.exists()) {
        if (file.open(QIODevice::ReadOnly)) {
            QString line = QString::fromUtf8(file.readAll());
            ui->textBrowser->setText(line);
            file.close();
        }
    } else {
        ui->textBrowser->append(tr("Produkt Datei (%1) nicht gefunden.").arg(file.fileName()));
    }


    QTextCursor cursor = ui->textBrowser->textCursor();
    cursor.setPosition(0);
    ui->textBrowser->setTextCursor(cursor);
}
