/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */
#ifndef HEADERPROXY_H
#define HEADERPROXY_H

#include "globals_ckvsoft.h"

#include <QAbstractProxyModel>

class CKVSOFT_EXPORT HeaderProxy : public QAbstractProxyModel {
    Q_OBJECT

public:
    explicit HeaderProxy(QObject *parent = Q_NULLPTR)
        : QAbstractProxyModel(parent)
    {
    }

    QModelIndex index(int row, int column, const QModelIndex &parent = QModelIndex()) const
    {
        if (!parent.isValid())
            return createIndex(row, column);
        return QModelIndex();
    }

    QModelIndex parent(const QModelIndex & /*child*/) const { return QModelIndex(); }

    QModelIndex mapToSource(const QModelIndex &proxyIndex) const
    {
        if (!proxyIndex.isValid())
            return QModelIndex();

        return createIndex(proxyIndex.row(), proxyIndex.column());
    }

    QModelIndex mapFromSource(const QModelIndex &sourceIndex) const
    {
        if (!sourceIndex.isValid())
            return QModelIndex();

        return index(sourceIndex.row(), sourceIndex.column());
    }

    int rowCount(const QModelIndex &parent) const { return sourceModel()->columnCount(parent); }

    int columnCount(const QModelIndex & /*parent*/) const { return 1; }

    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const
    {
        return sourceModel()->headerData(index.row(), Qt::Horizontal, role);
    }

    Qt::ItemFlags flags(const QModelIndex & /* index */) const { return Qt::ItemIsSelectable | Qt::ItemIsEnabled; }
};

#endif // HEADERPROXY_H
