/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#ifndef NUMERICKEYPAD_H
#define NUMERICKEYPAD_H

#include "globals_ckvsoft.h"

#include <QWidget>

class QLineEdit;
class PushButton;

enum NUMPAD_VALUE_BUTTON {
    NUMPAD_VALUE_BUTTON_COUNT,
    NUMPAD_VALUE_BUTTON_PRODUCTNUMBER,
    NUMPAD_VALUE_BUTTON_PRODUCT,
    NUMPAD_VALUE_BUTTON_NET,
    NUMPAD_VALUE_BUTTON_TAX,
    NUMPAD_VALUE_BUTTON_SINGLE,
    NUMPAD_VALUE_BUTTON_DISCOUNT,
    NUMPAD_VALUE_BUTTON_TOTAL,
    NUMPAD_VALUE_BUTTON_DESCBUTTON,
    NUMPAD_VALUE_BUTTON_SAVE,
    NUMPAD_VALUE_BUTTON_STR,
    NUMPAD_VALUE_BUTTON_TYPE_STR
};

class CKVSOFT_EXPORT NumericKeypad : public QWidget {
    Q_OBJECT

public:
    NumericKeypad(bool full = true, QWidget *parent = Q_NULLPTR);
    void clear();

    const QString text() const;
    void discountButtonSetEnabled(bool enabled);
    void setDiscountButtonHidden(bool hidden);
    void setCountButtonHidden(bool hidden);
    void setSinglePriceButtonHidden(bool hidden);
    void setPriceButtonHidden(bool hidden);
    void setEditFocus();

public slots:
    void setText(const QString &text);
    void setCount(bool);
    void setDiscount(bool);
    void setSinglePrice(bool);
    void setPrice(bool);
    void backspace(bool);

signals:
    void textChanged(const QString &text);
    void valueButtonPressed(const QString &text, NUMPAD_VALUE_BUTTON button);

private slots:
    void buttonClicked(const QString &text);

private:
    PushButton *m_buttonDiscount = Q_NULLPTR;
    PushButton *m_buttonCount = Q_NULLPTR;
    PushButton *m_buttonSinglePrice = Q_NULLPTR;
    PushButton *m_buttonPrice = Q_NULLPTR;
    QLineEdit *m_lineEdit;
    QString m_text;
    int m_digits = 2;
};

#endif // NUMERICKEYPAD_H
