/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#include "texteditdialog.h"
#include "pushbutton.h"

#include <QVBoxLayout>

TextEditDialog::TextEditDialog(QWidget *parent)
    : QDialog(parent)
{
    setWindowFlags(windowFlags() & ~Qt::WindowContextHelpButtonHint);
    setWindowTitle(tr("Beschreibungstext"));

    QVBoxLayout *vboxLayout = new QVBoxLayout(this);
    QVBoxLayout *editLayout = new QVBoxLayout();

    m_textEdit = new QTextEdit(this);
    editLayout->addWidget(m_textEdit);
    QHBoxLayout *hboxLayout = new QHBoxLayout();
    QSpacerItem *spacer = new QSpacerItem(40, 20, QSizePolicy::Expanding, QSizePolicy::Minimum);
    hboxLayout->addItem(spacer);
    PushButton *saveButton = new PushButton(this);
    saveButton->setIcon(QIcon(":/ckvsoft/resources/icons/save.png"));
    saveButton->setIconSize(QSize(32, 32));
    saveButton->setText(tr("Speichern"));
    hboxLayout->addWidget(saveButton);
    PushButton *exitButton = new PushButton(this);
    exitButton->setText(tr("Verlassen"));
    exitButton->setIcon(QIcon(":/ckvsoft/resources/icons/cancel.png"));
    exitButton->setIconSize(QSize(32, 32));
    hboxLayout->addWidget(exitButton);
    editLayout->addLayout(hboxLayout);

    vboxLayout->addLayout(editLayout);

    connect(saveButton, &QPushButton::clicked, this, &TextEditDialog::accept);
    connect(exitButton, &QPushButton::clicked, this, &TextEditDialog::close);
}

TextEditDialog::~TextEditDialog()
{
}

void TextEditDialog::setText(const QString &text)
{
    m_textEdit->setText(text);
}

QString TextEditDialog::getText()
{
    return m_textEdit->toPlainText();
}
