/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */
#ifndef SETTINGSWIDGET_H
#define SETTINGSWIDGET_H

#include "3rdparty/ckvsoft/widget.h"

#include <QJsonObject>

class SettingsWidget : public Widget {
    Q_OBJECT
public:
    SettingsWidget(QWidget *parent = Q_NULLPTR);
    bool maybeSave();

protected:
    void setInitial(const QJsonObject &data)
    {
        m_initialData = data;
        set(data);
    }
    void set(const QJsonObject &data)
    {
        m_jsonValues = data;
    }
    void set(const QString &key, const QVariant &value)
    {
        m_jsonValues.insert(key, QJsonValue::fromVariant(value));
    }
    bool isModified();

private:
    QJsonObject get();
    //    virtual bool save() = 0;

    QJsonObject m_jsonValues;
    QJsonObject m_initialData;
    bool m_ismodified = false;
};

#endif // SETTINGSWIDGET_H
