/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#include "taxedit.h"
#include "3rdparty/ckvsoft/csqlquery.h"
#include "database.h"

#include "ui_taxedit.h"

#include <QDebug>
#include <QDoubleValidator>
#include <QJsonArray>
#include <QJsonDocument>
#include <QJsonObject>
#include <QMessageBox>
#include <QPageSize>
#include <QSqlError>


//--------------------------------------------------------------------------------
TaxEdit::TaxEdit(QWidget *parent, int id)
    : QDialog(parent)
    , ui(new Ui::TaxEdit)
    , m_id(id)
{
    ui->setupUi(this);

    QDoubleValidator *doubleVal = new QDoubleValidator(0.0, 99.99, 2, this);
    doubleVal->setNotation(QDoubleValidator::StandardNotation);
    ui->name->setValidator(doubleVal);

    QSqlDatabase dbc = Database::database();

    if (m_id != -1) {
        CSqlQuery query(dbc, Q_FUNC_INFO);
        query.exec(QString("SELECT id, tax FROM taxtypes WHERE id=%1").arg(id));
        query.next();

        ui->name->setText(query.value("tax").toString());
    }
    connect(ui->okButton, &QrkPushButton::clicked, this, &TaxEdit::accept);
    connect(ui->cancelButton, &QrkPushButton::clicked, this, &TaxEdit::close);
}

TaxEdit::~TaxEdit()
{
    delete ui;
}

void TaxEdit::accept()
{

    if (ui->name->text().isEmpty()) return;

    updateData(m_id, ui->name->text());

    QDialog::accept();
}

//--------------------------------------------------------------------------------

bool TaxEdit::updateData(int id, const QString &name)
{
    QSqlDatabase dbc = Database::database();
    CSqlQuery query(dbc, Q_FUNC_INFO);

    if (id == -1) {
        query.prepare(QString("INSERT INTO taxtypes (tax, comment, taxlocation) "
                              "VALUES(:name, :comment, :taxlocation)"));
        query.bindValue(":comment", "Satz-Erweitert");
        query.bindValue(":taxlocation", Database::getTaxLocation());

    } else {
        query.prepare(QString("UPDATE taxtypes SET tax=:name WHERE id=:id"));
        query.bindValue(":id", id);
    }

    double tax = name.toDouble();
    if (tax == 0.0) return false;
    if (tax_exists(tax)) return false;

    query.bindValue(":name", tax);

    return query.exec();
}

bool TaxEdit::tax_exists(double tax)
{
    QSqlDatabase dbc = Database::database();
    CSqlQuery query(dbc, Q_FUNC_INFO);

    query.prepare("SELECT * FROM taxtypes WHERE tax=:tax AND taxlocation=:taxlocation");
    query.bindValue(":tax", tax);
    query.bindValue(":taxlocation", Database::getTaxLocation());
    query.exec();
    if (query.next()) return true;

    return false;
}
