/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#ifndef COUPONREDEMPTION_H
#define COUPONREDEMPTION_H

#include "defines.h"

#include <QMap>
#include <QWidget>

class ReceiptItemModel;

namespace Ui {
class CouponRedemption;
}

class CouponRedemption : public QWidget {
    Q_OBJECT

public:
    explicit CouponRedemption(ReceiptItemModel *model, QWidget *parent = nullptr);
    ~CouponRedemption();

    void setValue(const QString &key, const QString &value);
    static bool update(QMap<QString, QVariant> &arguments);

signals:
    void valueChanged(const QString &key, const QString &value);
    void cancel();
    void accepted();

private:
    Ui::CouponRedemption *ui;
    ReceiptItemModel *m_model = Q_NULLPTR;
    void checkBoxStateChanged(int state);
    void redeemChanged(QString value);
    void couponcode(QString code);
    QMap<QString, double> groupAndSum(REGISTER_COL taxColumn, REGISTER_COL sumColumn);
    QMap<QString, double> m_summap;

    int m_credit = 0;
    int m_available = 0;
    int m_toPay = 0;
};

#endif // COUPONREDEMPTION_H
