/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#include "customtoolbutton.h"
#include "preferences/settings.h"

#include <QAction>

CustomToolButton::CustomToolButton(QWidget *parent)
    : QToolButton(parent)
{
    initialize();
}

void CustomToolButton::setMinimumSize(const QSize newsize)
{
    Settings settings;
    QSize size = settings.value("ButtonSize", QSize(150, 60)).toSize();
    size.setWidth(newsize.width());
    QToolButton::setMinimumSize(size);
}

void CustomToolButton::initialize()
{
    setPopupMode(QToolButton::MenuButtonPopup);
    connect(this, &CustomToolButton::triggered, this, &CustomToolButton::setDefaultAction);
    setStyle(new CenteredToolButtonStyle(this, QSize(32, 32)));

    Settings settings;
    QSize size = settings.value("ButtonSize", QSize(150, 60)).toSize();
    QToolButton::setFixedHeight(size.height());
    QToolButton::setMinimumWidth(size.width());
}


CenteredToolButtonStyle::CenteredToolButtonStyle(QToolButton *b, const QSize &sIcon)
    : QProxyStyle()
    , B(b)
    , SICON(sIcon)
    , m_nf(0)
    , m_ny(0)
    , m_bEnabled(true)
{
    b->setToolButtonStyle(Qt::ToolButtonTextBesideIcon);
    setParent(b);
}
void CenteredToolButtonStyle::drawItemText(QPainter *painter, const QRect &rect, int flags, const QPalette &pal,
    bool enabled, const QString &text, QPalette::ColorRole textRole /* = QPalette::NoRole*/) const
{
    m_s = text;
    m_r = rect;
    m_nf = flags | Qt::AlignCenter;
    m_bEnabled = enabled;
    m_pal = pal;
    m_textRole = textRole;
    Draw(painter);
}
void CenteredToolButtonStyle::Draw(QPainter *painter) const
{
    if (m_ny) {
        if (m_r.y() != m_ny) return;
        auto r = m_r;
        r.adjust(-SICON.width() - 8, m_ny = 0, -itemTextRect(B->fontMetrics(), m_r, m_nf, m_bEnabled, m_s).width(), 0);
        QProxyStyle::drawItemPixmap(painter, r, Qt::AlignCenter, m_pic);
    }
    QProxyStyle::drawItemText(painter, m_r, m_nf, m_pal, m_bEnabled, m_s, m_textRole);
}
