/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */
#ifndef LOGUPLOADER_H
#define LOGUPLOADER_H

#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QObject>
#include <QUrl>

#include "globals_ckvsoft.h"


class CKVSOFT_EXPORT LogUploader : public QObject {
    Q_OBJECT

public:
    explicit LogUploader(QObject *parent = nullptr);
    void uploadLog(const QString &logFilePath, const QString &deviceId, const QUrl &serverUrl);

signals:
    void uploadFinished(bool success, const QString &message);
    void uploadProgress(qint64 bytesSent, qint64 bytesTotal);

private slots:
    void onUploadFinished(QNetworkReply *reply);

private:
    QNetworkAccessManager networkManager;
    QString highlightLogFileAsString(const QString &plainTextPath);
    QString zipLogFile(const QString &logPath);
};

#endif // LOGUPLOADER_H
