/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#ifndef SORTFILTERSQLQUERYMODEL_H
#define SORTFILTERSQLQUERYMODEL_H

#include "globals_ckvsoft.h"

#include <QObject>
#include <QSqlQueryModel>

class CKVSOFT_EXPORT SortFilterSqlQueryModel : public QSqlQueryModel {
    Q_OBJECT

public:
    explicit SortFilterSqlQueryModel(QObject *parent = Q_NULLPTR);

    // void setQuery(const CSqlQuery &query);
    void setQuery(const QString &query, const QSqlDatabase &dbc = QSqlDatabase::database());
    QString getFilterColumnName();
    int getFilterColumnId();

signals:
    void sortChanged();

public slots:

    void setFilterColumn(const QString &column);
    void setFilterFlags(const Qt::MatchFlag flags);
    void setFilter(const QString &filter);
    void filter(const QString &filter);

    void select();

    virtual void setSort(int column, Qt::SortOrder order);
    virtual void sort(int column, Qt::SortOrder order);

private:
    QSqlDatabase m_dbc;
    QString m_queryClause;
    Qt::MatchFlag m_filterFlags;
    QString m_filterString;
    QString m_filterColumn;
    int m_sortKeyColumn;
    Qt::SortOrder m_sortOrder;
};

#endif // QSORTFILTERSQLQUERYMODEL_H
