/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */
#include "verification.h"

#include <QFile>
#include <QJsonDocument>
#include <QJsonObject>
#include <QTextStream>

Verification::Verification(QObject *parent)
    : QObject(parent)
{
}

QJsonObject Verification::readJsonFromString(const QString &data)
{

    QStringList list = data.split("\n");
    QListIterator<QString> iter(list);
    QString json = "";
    while (iter.hasNext()) {
        QString line = iter.next();
        if (line.startsWith("----")) continue;
        json.append(line);
    }
    return QJsonDocument::fromJson(json.toUtf8()).object();
}

QJsonObject Verification::readJsonFromFile(const QString &filename)
{
    QFile inputFile(filename);
    if (inputFile.open(QIODevice::ReadOnly)) {
        QString json;
        QTextStream in(&inputFile);
        while (!in.atEnd()) {
            QString line = in.readLine();
            if (line.startsWith("----")) continue;
            json.append(line);
        }
        inputFile.close();
        return QJsonDocument::fromJson(json.toUtf8()).object();
    }

    return QJsonObject();
}

QString Verification::getSignedText(const QJsonObject &obj)
{
    QString serialNumber = obj["SerialNumberScard"].toString().isEmpty() ? obj["SerialNumber"].toString()
                                                                         : obj["SerialNumberScard"].toString();

    return obj["CashRegisterId"].toString() + ";" + obj["OrderMail"].toString() + ";" + obj["Date"].toString() + ";"
        + obj["Customer"].toString() + ";" + obj["Product"].toString() + ";" + obj["ValidTill"].toString() + ";"
        + serialNumber + ";";
}

QString Verification::readKeyFromFile(const QString &filename)
{
    QFile file(filename);
    file.open(QFile::ReadOnly | QFile::Text);
    QTextStream in(&file);
    return in.readAll();
}
