/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#ifndef BACKUP_H
#define BACKUP_H

#include "qrkcore_global.h"
#include <QDir>

class QString;

class QRK_EXPORT Backup {
public:
    static void create(QString dataDir);
    static void create();
    static void restore(QString filename, bool restart = false, bool rename = false);
    static void pakLogFile();
    static void cleanBackupTempDirectory();

private:
    static bool copyDatabaseFiles(const QStringList &fileList, const QString &destinationDir, const QString &tempname);
};

#endif // BACKUP_H
