/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */
#ifndef BACKUPWORKER_H
#define BACKUPWORKER_H

#include "qrkcore_global.h"

#include <QObject>
#include <QRunnable>

class QRK_EXPORT BackupWorker : public QObject, public QRunnable {
    Q_OBJECT

public:
    explicit BackupWorker(const QStringList &fullpathFilelist, const QString &backupDir, const QString &tempname,
        const QString &confname);
    ~BackupWorker();

    void run() override;
    static bool removeDir(const QString &dirName);

signals:
    void finishedCopyFiles();

private:
    void exportTables(const QString &backupDir, const QString &configName, QString &filename);
    void removeOldestFiles();
    QString getCreateTable(const QString &tablename);
    bool copyDatabaseFiles(const QStringList &filePaths, const QString &destinationDir, const QString &tempname);

    QStringList m_fullpathFilelist;
    QString m_backupDir;
    QString m_tempname;
    QString m_confname;
};

#endif // BACKUPWORKER_H
