/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#ifndef DOCUMENTPRINTER_H
#define DOCUMENTPRINTER_H

#include "qrkcore_global.h"
#include <QFont>
#include <QObject>

class QPrinter;
class QTextDocument;

class QRK_EXPORT DocumentPrinter : public QObject {
    Q_OBJECT

public:
    DocumentPrinter(QObject *parent = Q_NULLPTR);
    ~DocumentPrinter();

    void printReceipt(QJsonObject data);
    void printReceipt(QPrinter *printer, QJsonObject data);
    void printDocument(QPrinter *printer, QTextDocument *document);
    void printDocument(QTextDocument *document, const QString &title);
    void printTestDocument(QFont font);
    void printTagged(QJsonObject data);
    void printCollectionReceipt(QJsonObject data);

private:
    QString wordWrap(QString text, int width, QFont font);
    //    bool initPrinter(QPrinter &printer);
    //    bool initAlternatePrinter(QPrinter &printer);
    //    bool initInvoiceCompanyPrinter(QPrinter &printer);
    void drawVoidLines(QPainter &painter, int y, int width);
    QString createdVersionInfo(QString version);
    void printI(QJsonObject data, QPrinter *printer);
    double getFactor(int pixel, QPrinter *printer);

    bool m_noPrinter;
    QString m_pdfPrinterPath;
    bool m_printCollectionsReceipt;
    //    int m_collectionsReceiptCopies;
    bool m_smallPrinter;
    bool m_printQRCode;
    int m_receiptNum;
    bool m_logoRight;
    int m_numberCopies;
    QString m_paperFormat;
    QString m_collectionsReceiptText;
    bool m_useReportPrinter;
    QString m_currency;
    QString m_logoFileName;
    QString m_advertisingFileName;
    bool m_printCompanyNameBold;
    QFont m_receiptPrinterFont;
    QFont m_printerFont;
    QFont m_taggedPrinterFont;

    int m_feedProdukt;
    int m_feedCompanyHeader;
    int m_feedCompanyAddress;
    int m_feedCashRegisterid;
    int m_feedTimestamp;
    int m_feedTax;
    int m_feedPrintHeader;
    int m_feedHeaderText;
    int m_feedQRCode;
    bool m_printQrCodeLeft;
    bool m_useDecimalQuantity;
    bool m_interimCalculation = false;
    int m_defaultPaperWidth;
    int m_countDigits;
};

#endif // DOCUMENTPRINTER_H
