/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */
#include "qrkwaiterlockacs.h"
#include "3rdparty/ckvsoft/rbac/acl.h"
#include "utils/waiterlock.h"

QrkWaiterLockACS::QrkWaiterLockACS(QDialog *parent)
    : ACSInterface(parent)
{
}

int QrkWaiterLockACS::execute(int userid)
{
    const QString title = tr("Kellnerschloß Zuweisung für %1 ändern").arg(RBAC::Instance()->getUsername(userid));
    setWindowTitle(title);
    m_userid = userid;

    loginLabel->setText(tr("ACS Key"));
    passwordLabel->setHidden(true);
    passwordLineEdit->setHidden(true);
    userLineEdit->setFocus();
    okPushButton->setText(tr("Ändern"));
    cancelPushButton->setText(tr("Zurück"));

    savePasswordCheckBox->setVisible(false);
    windowNameLabel->setText(tr("Kellnerschloß Zuweisung"));
    windowCommentLabel->setText("ACHTUNG: Änderungen müssen danach noch im Manager gespeichert werden.");
    windowCommentLabel->setWordWrap(true);
    programVersionLabel->setText("");
    programVersionNoLabel->setText("");
    logoLabel->setPixmap(QPixmap(":/ckvsoft/resources/icons/password.png").scaled(48, 48, Qt::KeepAspectRatio));

    connect(m_waiterlock, &WaiterLock::request, [this](QString key) {
        userLineEdit->setText(key);
    });
    connect(cancelPushButton, &QPushButton::clicked, this, &QrkWaiterLockACS::reject);
    connect(okPushButton, &QPushButton::clicked, this, &QrkWaiterLockACS::OnChange);
    userLineEdit->setText(m_waiterlock->getKeyValue());
    int rvalue = exec();
    disconnect(m_waiterlock, &WaiterLock::request, Q_NULLPTR, Q_NULLPTR);
    return rvalue;
}

void QrkWaiterLockACS::OnChange()
{
    disconnect(m_waiterlock, &WaiterLock::request, Q_NULLPTR, Q_NULLPTR);

    SecureByteArray acskey = userLineEdit->text().toUtf8();

    Crypto crypto;
    QString cryptAcsKey = crypto.encrypt(acskey, SecureByteArray("acskey"));

    m_acskey = cryptAcsKey;
    QDialog::accept();
    QDialog::close();
}

QString QrkWaiterLockACS::getAcsKey()
{
    return m_acskey;
}

void QrkWaiterLockACS::setWaiterLock(WaiterLock *wl)
{
    m_waiterlock = wl;
}
