/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#ifndef QRKGASTROFINISHTICKET_H
#define QRKGASTROFINISHTICKET_H

#include "qrkgastro_global.h"

#include <QWidget>

class ReceiptItemModel;
class IndependentInterface;
class QRKGASTRO_EXPORT QRKGastroFinishTicket : public QWidget {
    Q_OBJECT

public:
    QRKGastroFinishTicket(bool paycash, QWidget *parent = Q_NULLPTR);
    ~QRKGastroFinishTicket();
    bool createReceipt(int ticket);
    void calculateReceipt(QList<int> ticketList, const QString roomtableName);

private:
    ReceiptItemModel *m_receiptitemmodel;
    QJsonObject findValueFromJsonArray(QJsonArray arr, QString key, QVariant val, int &id);
    bool payNow(int payedBy);
    bool finishReceipts(int, int = 0, bool = false);
    bool m_useGivenDialog = true;
    bool m_receiptPrintDialog = true;
    bool m_curfewoveride = false;
    bool m_paycash = false;
    bool m_proofs_guestname;
    bool m_minstockDialog;
    int m_currentReceipt = 0;
};

#endif // QRKGASTROFINISHTICKET_H
