/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */
/*
 * Manipulationssicherheit
 * Die Datenbank für das DEP-7 wird in der Hauptdatenbank mitgeführt, ist
 * allerdings vom User nicht direkt les- oder änderbar. Durch die Kombination
 * aus fortlaufender Sequenznummer und dem Hashwert aus den Zeileneinträgen ist
 * das DEP-7 auch nach dem Export vor Manipulation geschützt.
 */

#include "exportdep.h"
#include "3rdparty/ckvsoft/singleton/spreadsignal.h"
#include "exportdialog.h"
#include <QMessageBox>
#include <QString>

ExportDEP::ExportDEP(QObject *parent)
    : Export(parent)
{
}

ExportDEP::~ExportDEP()
{
}

void ExportDEP::dExport()
{
    ExportDialog dlg(true);
    if (dlg.exec() == QDialog::Accepted) {
        QString filename = dlg.getFilename();
        if (depExport(filename, dlg.getFrom(), dlg.getTo())) {
            Spread::Instance()->setProgressBarValue(-1);
            QMessageBox::information(Q_NULLPTR, tr("Export"),
                tr("DEP-7 (Daten-Erfassungs-Protokol) wurde nach %1 exportiert.").arg(filename));
        } else {
            Spread::Instance()->setProgressBarValue(-1);
            QMessageBox::warning(Q_NULLPTR, tr("Export"),
                tr("DEP-7 (Daten-Erfassungs-Protokol) konnte nicht "
                   "nach %1 exportiert werden.\nÜberprüfen Sie "
                   "bitte Ihre Schreibberechtigung.")
                    .arg(filename));
        }
    }
}
