/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2024 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#include "a_signacos_ID_V41.h"

/**
 * @brief ASignACOS_IDV41::ASignACOS_IDV41
 * @param device_name
 * @param shared
 */
ASignACOS_IDV41::ASignACOS_IDV41(QString device_name, bool shared)
    : ASignACOS_ID(device_name, shared)
{
    m_CIN = "";
    m_DF_SIG_Selected = false;
}

/**
 * @brief ASignACOS_IDV41::getCardType
 * @return
 */
QString ASignACOS_IDV41::getCardType()
{
    return QObject::tr("A-Trust ACOS_ID V41");
}

QString ASignACOS_IDV41::getExpireInfo()
{
    /*
    QString expiryDate = "";
    return QObject::tr("%1 ist ungültig und kann nicht mehr für eine RKSV-konforme Signierung verwendet werden.%2 Bitte
    bestellen Sie eine neue Karte bei A-Trust.") .arg(getCardType()) .arg(expiryDate.isEmpty() ? "" : QObject::tr(" Die
    Karte war bis %1 gültig.").arg(expiryDate));
    */
    return "";
}
