BEGIN TRANSACTION;

DROP TABLE `coupon`;

CREATE TABLE "coupons" (
    "id"	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "timestamp"	NUMERIC NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "type"	INTEGER NOT NULL,
    "code"	TEXT NOT NULL,
    "customer"	INTEGER NOT NULL,
    "gross"	INTEGER NOT NULL,
    "credit"	INTEGER NOT NULL,
    "tax"	INTEGER NOT NULL,
    "storno"	INTEGER NOT NULL DEFAULT 0,
    "stornotimestamp"	NUMERIC,
    "deleted"	INTEGER NOT NULL DEFAULT 0,
    "reference"	TEXT NOT NULL,
    "checksum"  TEXT NOT NULL,
    "description"	TEXT NOT NULL,
    "userid"	INTEGER NOT NULL DEFAULT 0
);

CREATE TABLE coupon_redemptions (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    coupon_id INTEGER,
    redemption_date NUMERIC NOT NULL DEFAULT CURRENT_TIMESTAMP,
    redemption_amount INTEGER,
    FOREIGN KEY(coupon_id) REFERENCES coupons(id)
);

COMMIT;
