/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2025 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#ifndef DEFINES
#define DEFINES

#define QRK_VERSION_MAJOR "1.26.3"
#define QRK_VERSION_MINOR "Build-250424"
#define QRK_PRO           QString("ⓅⓇⓄ")

enum REGISTER_COL {
    REGISTER_COL_COUNT,
    REGISTER_COL_PRODUCTNUMBER,
    REGISTER_COL_PRODUCT,
    REGISTER_COL_NET,
    REGISTER_COL_TAX,
    REGISTER_COL_SINGLE,
    REGISTER_COL_DISCOUNT,
    REGISTER_COL_TOTAL,
    REGISTER_COL_DESCBUTTON,
    REGISTER_COL_TKTID,
    REGISTER_COL_COUNT_STR,
    REGISTER_COL_COUNT_TYPE_STR
};

enum DOCUMENT_COL {
    DOCUMENT_COL_RECEIPT,
    DOCUMENT_COL_TYPE,
    DOCUMENT_COL_INFO,
    DOCUMENT_COL_TOTAL,
    DOCUMENT_COL_DATE,
    DOCUMENT_COL_TEXT
};

// values for the receipt.payedBy field
enum PAYED_BY {
    FIRST_VALUE = -4,
    PAYED_BY_EMPLOYEE = -3,    // employee consumation
    PAYED_BY_ADVERTISING = -2, // does not have invoiceNum; was a gift
    PAYED_BY_PRIVATE = -1,     // private consumation
    PAYED_BY_CASH,
    PAYED_BY_DEBITCARD,
    PAYED_BY_CREDITCARD,
    PAYED_BY_COUPON,
    PAYED_BY_REPORT_EOD,
    PAYED_BY_REPORT_EOM,
    PAYED_BY_START_RECEIPT,
    PAYED_BY_CONTROL_RECEIPT,
    PAYED_BY_COLLECTING_RECEIPT,
    PAYED_BY_MONTH_RECEIPT,
    PAYED_BY_CONCLUSION_RECEIPT,
    PAYED_BY_YEAR_RECEIPT
};
/*  6,'Startbeleg'
    7,'Kontrollbeleg'
    8,'Sammelbeleg'
    9,'Monatsbeleg' == 'Jahresbeleg'
    10,'Schlussbeleg'
*/

enum JOURNAL_ACTION { JOURNAL_RECEIPT = 0 };

#endif // DEFINES
