/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2025 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#ifndef CASHBOOKDIALOG_H
#define CASHBOOKDIALOG_H

#include <QDialog>
#include <QModelIndex>

class QSqlTableModel;
class QSqlDatabase;
class QItemSelection;

enum CB_FLOW { FLOW_FIRST = -1, FLOW_IN, FLOW_OUT };
enum CB_TYPE { TYPE_FIRST = -1, TYPE_BUSINESS_AUTO, TYPE_BUSINESS, TYPE_PRIVATE };

namespace Ui {
class CashBookDialog;
}

class CashBookDialog : public QDialog {
    Q_OBJECT

public:
    explicit CashBookDialog(QDialog *parent = Q_NULLPTR);
    ~CashBookDialog();
    static QString getLastEntryDate();
    static QString getLastCheckSum();
    static bool updateDatabase();

protected slots:
    void onStornoButtonClicked();
    void onSelectionChanged(const QItemSelection &, const QItemSelection &);
    void timerDone();

signals:
    void error();

private:
    Ui::CashBookDialog *ui;
    QSqlTableModel *m_model = Q_NULLPTR;
    void init();
    void setupView();
    void setUiData();
    void insertNew();
    void readSettings();
    void writeSettings();

    bool checkDatabase();
    void initCashbookStartDate();
    void setSales(QDateTime date);
    int getBalanceCarriedForward(QDateTime date);
    void cancelation(int id, QString &description);
    bool dataBaseExists();

    QTimer *m_timer;
    // bool m_cash_repayment = true;
    QString m_startEntry = "";
    // QString m_lastEntry = "";
    QString m_currency = "";
    QString m_cash = "0";
};

#endif // CASHBOOKDIALOG_H
