/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2025 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#ifndef WSDLBACKUPSETTINGS_H
#define WSDLBACKUPSETTINGS_H

#include <QModelIndex>
#include <QWidget>

class QTreeView;
class QPushButton;
// class QDirModel;
class QFileSystemModel;
class QGroupBox;

class WsdlBackupSettings : public QWidget {
    Q_OBJECT

public:
    explicit WsdlBackupSettings(QWidget *parent = 0);

signals:
    void accept();

private slots:
    void buttonClicked(bool);
    void deleteButtonClicked(bool);
    void buttonEnabled(QModelIndex);

private:
    void viewGroupChanged(bool checked);

    QTreeView *m_view;
    QGroupBox *m_viewGroup;
    QFileSystemModel /* QDirModel */ *m_model;
    QPushButton *m_button;
    QPushButton *m_deleteButton;
    QString m_path;
    QModelIndex m_current = {};
};

#endif // WSDLBACKUPSETTINGS_H
