/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2025 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#ifndef FVUPDATEWINDOW_H
#define FVUPDATEWINDOW_H

#if QT_VERSION >= 0x050000
#    include <QtWidgets/QWidget>
#else
#    include <QWidget>
#endif

class QGraphicsScene;

namespace Ui {
class FvUpdateWindow;
}

class FvUpdateWindow : public QWidget {
    Q_OBJECT

public:
    explicit FvUpdateWindow(QWidget *parent, bool skipVersionAllowed, bool remindLaterAllowed);
    ~FvUpdateWindow();

    // Update the current update proposal from FvUpdater
    bool UpdateWindowWithCurrentProposedUpdate();

    void closeEvent(QCloseEvent *event);

private:
    Ui::FvUpdateWindow *m_ui;
    QGraphicsScene *m_appIconScene;
};

#endif // FVUPDATEWINDOW_H
