/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2025 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#ifndef QRKPRINTER_H
#define QRKPRINTER_H

#include "qrkcore_global.h"

#include <QObject>
#include <QPrinter>
#include <QSplashScreen>

class QRK_EXPORT QRKPrinter : public QObject {
    Q_OBJECT

public:
    explicit QRKPrinter(QString printername, QObject *parent = Q_NULLPTR);
    explicit QRKPrinter(int printerid, QObject *parent = Q_NULLPTR);
    explicit QRKPrinter(QSplashScreen *splash = Q_NULLPTR, QObject *parent = Q_NULLPTR);

    ~QRKPrinter();
    QList<QPrinter *> getPrinterList();
    static void clearGlobalPrinterList(const QString &printerName);
    static void clearAllGlobalResources();

private:
    void setDefaultPDFPrinter();
    void setDefinition(const QJsonObject &object, QPrinter *&printer);
    void initPrinters();
    QString m_printername;
    QList<QPrinter *> *m_printers;
};

#endif // QRKPRINTER_H
