#ifndef QRKVIEWER_H
#define QRKVIEWER_H

#include "3rdparty/ckvsoft/sortfiltersqlquerymodel.h"

#include <QMainWindow>

class QPrinter;
class QTextDocument;
class QItemSelection;

namespace Ui {
class QrkViewer;
}

class QrkViewer : public QMainWindow {
    Q_OBJECT

public:
    explicit QrkViewer(QWidget *parent = Q_NULLPTR);
    ~QrkViewer();

private:
    Ui::QrkViewer *ui;
    SortFilterSqlQueryModel *m_documentListModel = Q_NULLPTR;
    void documentTriggered(bool);
    void onDocumentSelectionChanged(const QItemSelection &, const QItemSelection &);
    void printButtonClicked();
    void filePrintPreview();
    void previewPrint(QPrinter *printer);
    QString m_documentfile;
    bool m_report_by_productgroup = false;
    bool qrcode;
};

#endif // QRKVIEWER_H
