/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2025 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#include <QDialog>
#include <QLabel>
#include <QVBoxLayout>

#include "3rdparty/profeatures/profeatures.h"
#include "cashbook.h"
#include "cashbookdialog.h"
#include "cashbooksettingswidget.h"
#include "database.h"

CashBook::CashBook(QObject *parent)
    : IndependentInterface()
{
    setParent(parent);
    m_root = new QDialog;
}

CashBook::~CashBook()
{
}

bool CashBook::process(QMap<QString, QVariant> &arguments)
{

    if (arguments.contains("whatever") && arguments.value("whatever").toInt() == 1)
        return CashBookDialog::updateDatabase();

    CashBookDialog dialog;
    if (isActivated()) {
        dialog.setWindowTitle(getPluginName());
        dialog.exec();
    } else {
        SettingsDialog()->exec();
    }
    return true;
}

QDialog *CashBook::SettingsDialog()
{
    QVBoxLayout *layout = new QVBoxLayout;
    CashBookSettingsWidget *sw = new CashBookSettingsWidget;
    layout->addWidget(sw);
    m_root->setLayout(layout);
    connect(sw, &CashBookSettingsWidget::saved, m_root, &QDialog::close);
    connect(sw, &CashBookSettingsWidget::rejected, m_root, &QDialog::reject);
    return m_root;
}

bool CashBook::isActivated()
{
    QVariant value;
    QString strValue;

    Database::select_globals("cashbook_active", value, strValue);
    return value.toBool() && ProFeatures::isValid();
}
