/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2024 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#ifndef PRIMESIGNSMARTCARD_H
#define PRIMESIGNSMARTCARD_H

// prime.sign Commands

// #define PRIMESIGN_CMD_VERIFY "\x00\x20\x00\x81\x08\x26\x35\x55\x30\xFF\xFF\xFF\xFF"
#define PRIMESIGN_CMD_VERIFY "\x00\x20\x00\x81\x08\x26\x35\x53\x0F\xFF\xFF\xFF\xFF"


const unsigned char PRIMESIGN_CMD_COMPUTE_DIGITAL_SIGNATURE[] = { 0x00, 0x2A, 0x9E, 0x9A, 0x20 };
const unsigned char PRIMESIGN_SELECT_DF_QES[] = { 0x00, 0xA4, 0x08, 0x0C, 0x02, 0x3F, 0x04 };
const unsigned char PRIMESIGN_SELECT_EF_C_X509_CH_DS[] = { 0x00, 0xA4, 0x02, 0x0C, 0x02, 0xC0, 0x00 };
const unsigned char PRIMESIGN_CMD_READ_BINARY[] = { 0x00, 0xB0, 0x00, 0x00, 0x00, 0x00, 0x00 };

#include "rk_signaturesmartcard.h"

#include "../globals_ckvsoft.h"

class QString;

class CKVSOFT_EXPORT PrimeSignSmartCard : public RKSignatureSmartCard {

public:
    PrimeSignSmartCard(QString device_name, bool shared);
    ~PrimeSignSmartCard();

    bool selectApplication() override;
    virtual QString getCardType() override = 0;
    virtual QString getSVI() override = 0;

protected:
    bool m_DF_QES_Selected = false;

    virtual ASignResponse signHash(const unsigned char hash[32]) = 0;

    ASignResponse transmit(const unsigned char *txBuffer, DWORD txLength);
    QString getMessage(const unsigned char code[2]);
    QByteArray ReadFile();
    QString hexToDecimalString(const QByteArray &hex);
};

//---------------------------------------------------------------------------

#endif // PRIMESIGNSMARTCARD_H
