SET FOREIGN_KEY_CHECKS=0;
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;

CREATE TABLE `actiontypes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `actionId` int(11) NOT NULL,
  `actionText` text NOT NULL,
  `comment` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `actiontypes` (`id`, `actionId`, `actionText`, `comment`) VALUES
(1, 0, 'BAR', 'payedByText'),
(2, 1, 'Bankomat', 'payedByText'),
(3, 2, 'Kreditkarte', 'payedByText'),
(4, 3, 'Gutschein','PayedByText'),
(5, 4, 'Tagesabschluss', 'PayedByText'),
(6, 5, 'Monatsabschluss', 'PayedByText'),
(7, 6, 'Startbeleg','PayedByText'),
(8, 7, 'Kontrollbeleg','PayedByText'),
(9, 8, 'Nullbeleg','PayedByText'),
(10, 9, 'Monatsbeleg','PayedByText'),
(11, 10, 'Schlussbeleg','PayedByText'),
(12, -1, 'Privat','PayedByText'),
(13, -2, 'Werbung','PayedByText'),
(14, -3, 'Personal','PayedByText'),
(15, 11, 'Jahresbeleg','PayedByText');

CREATE TABLE `customer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `receiptNum` int(11) DEFAULT NULL,
  `text` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE `history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `datetime` datetime NOT NULL,
  `data` text,
  `userId` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `journal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version` text NOT NULL,
  `cashregisterid` text NOT NULL,
  `datetime` datetime NOT NULL,
  `data` text,
  `checksum` text,
  `userId` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `dep` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `receiptNum` int(11),
  `data` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE `certs` (
    `id`       int(11) NOT NULL AUTO_INCREMENT,
    `serial`   VARCHAR(64) NOT NULL UNIQUE,
    `cert`     TEXT NOT NULL,
    `pin`      VARCHAR(13),
    `created`  TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `globals` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `value` int(11) DEFAULT NULL,
  `strValue` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `rooms` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `name` text,
    `color` text,
    `isHotel` int(11) NOT NULL DEFAULT '0',
    `sortorder` int(11) NOT NULL DEFAULT '0',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE  `tickets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `open` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'is this ticket being worked on (not payed yet)',
  `timestamp` datetime NOT NULL,
  `tableId` int(11) NOT NULL,
  `payedBy` int(11) NOT NULL DEFAULT '0',
  `guestname` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='they group orders per table';

CREATE TABLE  `ticketorders` (
  `id` INTEGER NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `ticketId` INTEGER NOT NULL REFERENCES `tickets` (`id`),
  `product` INTEGER NOT NULL REFERENCES `products` (`id`),
  `count` int(11) NOT NULL DEFAULT '1',
  `gross` double NOT NULL,
  `printed` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE INDEX `orders_ticketId_index` ON `ticketorders` (`ticketId`);

CREATE TABLE orderextras (
    orderId INT NOT NULL,
    ticketId INT,
    type INT,
    product INT NOT NULL,
    FOREIGN KEY (orderId) REFERENCES ticketorders(id),
    FOREIGN KEY (product) REFERENCES products(id),
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE INDEX `orderextras_orderId_index` ON `orderextras` (`orderId`);

CREATE TABLE `orderdescs` (
  `id` INTEGER NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `type` INTEGER NOT NULL,
  `orderId` INTEGER NOT NULL,
  `description` TEXT
);
CREATE INDEX `orderdescs_orderId_index` ON `orderdescs` (`orderId`);

CREATE TABLE `tables` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `roomId` int(11) NOT NULL,
    `name` text,
    `color` text,
    `sortorder` int(11) NOT NULL DEFAULT '0',
    PRIMARY KEY (`id`),
    KEY `roomId` (`roomId`),
    CONSTRAINT `roomId` FOREIGN KEY (`roomId`) REFERENCES `rooms` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE  `categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `color` text,
  `printerid` int(11) DEFAULT NULL,
  `image` text,
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `sortorder` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `categories`(`id`, `name`, `color`) VALUES (1, 'Standard', '#008b8b');

CREATE TABLE `groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `color` text,
  `printerid` int(11) DEFAULT NULL,
  `image` text,
  `tax` double,
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `categoryId` int(11) NOT NULL DEFAULT '1',
  `sortorder` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  CONSTRAINT `categoryId` FOREIGN KEY (`categoryId`) REFERENCES `categories` (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `groups` (`id`, `name`, `color`, `printerid`, `image`, `visible`) VALUES
(1, 'auto', '', 0, '', 0),
(2, 'Standard', '#008b8b', 0, '', 1);

CREATE TABLE `orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `receiptId` int(11) NOT NULL,
  `product` int(11) NOT NULL,
  `count` double NOT NULL DEFAULT '1',
  `discount` double NOT NULL DEFAULT '0',
  `net` double NOT NULL,
  `gross` double NOT NULL,
  `tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `orders_receiptId_index` (`receiptId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `itemnum` text NOT NULL,
  `barcode` text NOT NULL,
  `name` text NOT NULL,
  `sold` double NOT NULL DEFAULT '0',
  `net` double NOT NULL,
  `gross` double NOT NULL,
  `groupid` int(11) NOT NULL DEFAULT '2',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `completer` tinyint(1) NOT NULL DEFAULT '1',
  `tax` double NOT NULL DEFAULT '20',
  `color` varchar(255) DEFAULT '#808080',
  `button` varchar(255) DEFAULT '',
  `image` varchar(255) DEFAULT '',
  `coupon` tinyint(1) NOT NULL DEFAULT '0',
  `stock` double NOT NULL DEFAULT '0',
  `minstock` double NOT NULL DEFAULT '0',
  `version` int(11) NOT NULL DEFAULT '0',
  `origin` int(11) NOT NULL DEFAULT '0',
  `lastchange` TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
  `description` text,
  `sortorder` int(11) NOT NULL DEFAULT '0',
  `printerid` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groupid` (`groupid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE `receipts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `infodate` datetime NOT NULL,
  `receiptNum` int(11) DEFAULT NULL,
  `payedBy` int(11) NOT NULL DEFAULT '0',
  `gross` double NOT NULL DEFAULT '0',
  `r2b` int(11) NOT NULL DEFAULT '0',
  `storno` int(11) NOT NULL DEFAULT '0',
  `stornoId` int(11) NOT NULL DEFAULT '0',
  `userId` int(11) NOT NULL DEFAULT '0',
  `current_hash` VARCHAR(255),
  `previous_hash` VARCHAR(255),
  `isprinted` INT DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `receipts_stornoId_index` (`stornoId`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE `receiptspay` (
    `receiptNum`	INTEGER DEFAULT NULL,
    `payedBy`	INTEGER NOT NULL DEFAULT '0',
    `gross`	double NOT NULL DEFAULT '0',
    KEY `receiptspay_index` (`receiptNum`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE `reports` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `receiptNum` int(11) DEFAULT NULL,
  `timestamp` datetime NOT NULL,
  `text` text,
  `type`	INTEGER NOT NULL DEFAULT '0',
  `curfew`	varchar(5) NOT NULL DEFAULT '00:00',
  `timestampfrom` datetime NOT NULL DEFAULT '0000-00-00T00:00:00',
  PRIMARY KEY (`id`),
  KEY `reports_receiptNum_index` (`receiptNum`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE `printerdefs` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(255) NOT NULL,
  `definition` TEXT NOT NULL,
  `mode` INT NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE `printers` (
 `id` INT NOT NULL AUTO_INCREMENT,
 `name` VARCHAR(255) NOT NULL,
 `printer` VARCHAR(255) NOT NULL,
 `definition` INT NOT NULL DEFAULT '1',
 `mode` INT NOT NULL DEFAULT '0',
 PRIMARY KEY (`id`),
 CONSTRAINT `definition` FOREIGN KEY (`definition`) REFERENCES `printerdefs` (`id`)
 ) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE `taxtypes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax` double DEFAULT NULL,
  `comment` text,
  `taxlocation` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `taxTypes`
--

INSERT INTO `taxtypes` (`id`, `tax`, `comment`, `taxlocation`) VALUES
(1, 20, 'Satz-Normal', 'AT'),
(2, 10, 'Satz-Ermaessigt-1', 'AT'),
(3, 13, 'Satz-Ermaessigt-2', 'AT'),
(4, 19, 'Satz-Besonders', 'AT'),
(5, 0, 'Satz-Null', 'AT'),
(6, 19, 'Satz-Normal', 'DE'),
(7, 7, 'Satz-Ermaessigt-1', 'DE'),
(8, 0, 'Satz-Null', 'DE'),
(9, 7.7, 'Satz-Normal', 'CH'),
(10, 2.5, 'Satz-Ermaessigt-1', 'CH'),
(11, 3.7, 'Satz-Besonders', 'CH'),
(12, 0, 'Satz-Null', 'CH');

ALTER TABLE `orders`
  ADD CONSTRAINT `product` FOREIGN KEY (`product`) REFERENCES `products` (`id`);

ALTER TABLE `products`
  ADD CONSTRAINT `groupid` FOREIGN KEY (`groupid`) REFERENCES `groups` (`id`);

CREATE TABLE `permissions` (
    `ID` bigint(20) unsigned NOT NULL auto_increment,
    `permKey` varchar(255) NOT NULL,
    `permName` varchar(255) NOT NULL,
    PRIMARY KEY  (`ID`),
    UNIQUE KEY `permKey` (`permKey`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `roles` (
    `ID` bigint(20) unsigned NOT NULL auto_increment,
    `roleName` varchar(255) NOT NULL,
    PRIMARY KEY  (`ID`),
    UNIQUE KEY `roleName` (`roleName`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `role_perms` (
    `ID` bigint(20) unsigned NOT NULL auto_increment,
    `roleID` bigint(20) NOT NULL,
    `permID` bigint(20) NOT NULL,
    `value` tinyint(1) NOT NULL default '0',
    `addDate` datetime NOT NULL,
    PRIMARY KEY  (`ID`),
    UNIQUE KEY `roleID_2` (`roleID`,`permID`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `users` (
    `ID` int(10) unsigned NOT NULL auto_increment,
    `username` varchar(255) NOT NULL,
    `displayname` varchar(255) NOT NULL,
    `password` varchar(255) NOT NULL,
    `value` tinyint(1) NOT NULL default '0',
    `gender` tinyint(1) NOT NULL default '0',
    `avatar` varchar(255),
    `acskey` varchar(255),
    `addDate` datetime NOT NULL,
    PRIMARY KEY  (`ID`),
    UNIQUE (`acskey`),
    KEY `username` (`username`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `user_perms` (
    `ID` bigint(20) unsigned NOT NULL auto_increment,
    `userID` bigint(20) NOT NULL,
    `permID` bigint(20) NOT NULL,
    `value` tinyint(1) NOT NULL default '0',
    `addDate` datetime NOT NULL,
    PRIMARY KEY  (`ID`),
    UNIQUE KEY `userID` (`userID`,`permID`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `user_roles` (
    `userID` bigint(20) NOT NULL,
    `roleID` bigint(20) NOT NULL,
    `addDate` datetime NOT NULL,
    UNIQUE KEY `userID` (`userID`,`roleID`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `permissions` (ID, permKey, permName) VALUES
(1, 'register_access', 'Zugriff auf die Kasse'),
(2, 'register_r2b', 'Bon in Rechnung umwandeln'),
(3, 'documents_access', 'Zugriff auf Dokumente'),
(4, 'documents_cancellation', 'Dokumente stornieren'),
(5, 'tasks_access', 'Zugriff auf Aufgaben'),
(6, 'tasks_create_eod', 'Tagesabschluss-Aufgabe erstellen'),
(7, 'tasks_create_eom', 'Monatsabschluss-Aufgabe erstellen'),
(8, 'manager_access', 'Zugriff auf Managerbereich'),
(9, 'settings_access', 'Zugriff auf Einstellungen'),
(10, 'settings_view_masterdata', 'Zugriff auf Einstellungen: Stammdaten'),
(11, 'settings_edit_masterdata', 'Einstellungen: Stammdaten bearbeiten'),
(12, 'settings_view_printer', 'Zugriff auf Einstellungen: Drucker'),
(13, 'settings_edit_printer', 'Einstellungen: Drucker bearbeiten'),
(14, 'settings_view_receipt_printer', 'Zugriff auf Einstellungen: BON-Drucker'),
(15, 'settings_edit_receipt_printer', 'Einstellungen: BON-Drucker bearbeiten'),
(16, 'settings_view_receipt', 'Zugriff auf Einstellungen: Kassenbon'),
(17, 'settings_edit_receipt', 'Einstellungen: Kassenbon bearbeiten'),
(18, 'settings_view_receipt_text', 'Zugriff auf Einstellungen: Bontexte'),
(19, 'settings_edit_receipt_text', 'Einstellungen: Bontexte bearbeiten'),
(20, 'settings_view_paths', 'Zugriff auf Einstellungen: Verzeichnispfade'),
(21, 'settings_edit_paths', 'Einstellungen: Verzeichnispfade bearbeiten'),
(22, 'settings_view_extra', 'Zugriff auf Einstellungen: Zusatzdaten'),
(23, 'settings_edit_extra', 'Einstellungen: Zusatzdaten bearbeiten'),
(24, 'settings_view_importserver', 'Zugriff auf Einstellungen: Importserver'),
(25, 'settings_edit_importserver', 'Einstellungen: Importserver bearbeiten'),
(26, 'settings_view_see', 'Zugriff auf Einstellungen: Signatureinheit'),
(27, 'settings_edit_see', 'Einstellungen: Signatureinheit bearbeiten'),
(28, 'admin_access', 'Zugriff auf Administration'),
(29, 'admin_edit_user', 'Benutzer in der Administration bearbeiten'),
(30, 'admin_edit_userroles', 'Benutzerrollen in der Administration bearbeiten'),
(31, 'admin_edit_userperms', 'Benutzerrechte in der Administration bearbeiten'),
(32, 'admin_create_user', 'Benutzer in der Administration erstellen'),
(33, 'admin_delete_user', 'Benutzer in der Administration löschen'),
(34, 'admin_edit_role', 'Rollen in der Administration bearbeiten'),
(35, 'admin_create_role', 'Rollen in der Administration erstellen'),
(36, 'admin_delete_role', 'Rollen in der Administration löschen'),
(37, 'salesinfo_view', 'Zugriff auf Verkaufsinformationen'),
(38, 'import_csv', 'CSV-Daten importieren'),
(39, 'gastro_user_can_change_singleprice', 'Benutzer darf Einzelpreise ändern'),
(40, 'settings_edit_collection_receipt', 'Einstellungen: Sammelrechnung bearbeiten'),
(41, 'settings_edit_receipt_reports', 'Einstellungen: Belegberichte bearbeiten'),
(42, 'gastro_register_access', 'Zugriff auf die Gastro-Kasse'),
(43, 'plugin_run_cashbook', 'Kassenbuch-Plugin ausführen'),
(44, 'plugin_cashbook_access_editbox', 'Zugriff auf Bearbeitungsfeld im Kassenbuch-Plugin'),
(45, 'gastro_void_ticked', 'Artikel in der Gastro zur Stornierung auswählen'),
(46, 'plugin_run_chart', 'Diagramm-Plugin ausführen'),
(47, 'gastro_employee_ticked', 'Mitarbeiterartikel in der Gastro auswählen'),
(48, 'salesinfo_print', 'Verkaufsinformationen drucken'),
(49, 'gastro_advertising_ticked', 'Werbeartikel in der Gastro auswählen'),
(50, 'gastro_private_ticked', 'Privatartikel in der Gastro auswählen'),
(51, 'plugin_run_coupon', 'Coupon-Plugin ausführen'),
(52, 'plugin_coupon_access_editbox', 'Zugriff auf Bearbeitungsfeld im Coupon-Plugin');

SET FOREIGN_KEY_CHECKS=1;
COMMIT;
