BEGIN TRANSACTION;
ALTER TABLE receipts RENAME TO old_receipts_temp;

CREATE TABLE "receipts" (
    "id"            INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "timestamp"     datetime NOT NULL,
    "infodate"      datetime NOT NULL,
    "receiptNum"    INTEGER DEFAULT NULL,
    "payedBy"       INTEGER NOT NULL DEFAULT '0',
    "gross"         double NOT NULL DEFAULT '0',
    "r2b"           INTEGER NOT NULL DEFAULT '0',
    "storno"        INTEGER NOT NULL DEFAULT '0',
    "stornoId"      INTEGER NOT NULL DEFAULT '0',
    "userId"        INTEGER NOT NULL DEFAULT '0',
    "current_hash"  TEXT,
    "previous_hash" TEXT,
    "isprinted"     INTEGER DEFAULT '1',
    "unix_timestamp" INTEGER DEFAULT (strftime('%s', 'now'))
);

INSERT INTO receipts (
    id, timestamp, infodate, receiptNum, payedBy, gross, r2b, storno, stornoId,
    userId, current_hash, previous_hash, isprinted, unix_timestamp
)
SELECT
    id, timestamp, infodate, receiptNum, payedBy, gross, r2b, storno, stornoId,
    userId, current_hash, previous_hash, isprinted,
    strftime('%s', timestamp)
FROM old_receipts_temp;

DROP TABLE old_receipts_temp;


ALTER TABLE reports RENAME TO old_reports_temp;

CREATE TABLE "reports" (
    "id"            INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "receiptNum"    INTEGER,
    "timestamp"     datetime NOT NULL,
    "text"          text,
    "type"          INTEGER NOT NULL DEFAULT 0,
    "curfew"        text NOT NULL DEFAULT '00:00',
    "timestampfrom" datetime NOT NULL DEFAULT '0000-00-00T00:00:00',
    "unix_timestamp" INTEGER DEFAULT (strftime('%s', 'now'))
);

INSERT INTO reports (
    id, receiptNum, timestamp, text, type, curfew, timestampfrom, unix_timestamp
)
SELECT
    id, receiptNum, timestamp, text, type, curfew, timestampfrom,
    strftime('%s', timestamp)
FROM old_reports_temp;

DROP TABLE old_reports_temp;
CREATE INDEX IF NOT EXISTS `reports_receiptNum_index` ON `reports` (`receiptNum`);

ALTER TABLE tickets RENAME TO old_tickets_temp;

CREATE TABLE "tickets" (
    "id"            INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "open"          tinyint(1) NOT NULL DEFAULT '1',
    "timestamp"     datetime NOT NULL,
    "tableId"       int(11) NOT NULL,
    "payedBy"       int(11) NOT NULL DEFAULT '0',
    "guestname"     TEXT,
    "unix_timestamp" INTEGER DEFAULT (strftime('%s', 'now'))
);

INSERT INTO tickets (
    id, open, timestamp, tableId, payedBy, guestname, unix_timestamp
)
SELECT
    id, open, timestamp, tableId, payedBy, guestname,
    strftime('%s', timestamp)
FROM old_tickets_temp;

DROP TABLE old_tickets_temp;


ALTER TABLE journal RENAME TO old_journal_temp;

CREATE TABLE "journal" (
    "id"                INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "version"           text NOT NULL,
    "cashregisterid"    text NOT NULL,
    "datetime"          datetime NOT NULL,
    "data"              text,
    "checksum"          text,
    "userId"            INTEGER NOT NULL DEFAULT '0',
    "unix_timestamp" INTEGER DEFAULT (strftime('%s', 'now'))
);

INSERT INTO journal (
    id, version, cashregisterid, datetime, data, checksum, userId, unix_timestamp
)
SELECT
    id, version, cashregisterid, datetime, data, checksum, userId,
    strftime('%s', datetime)
FROM old_journal_temp;

DROP TABLE old_journal_temp;


ALTER TABLE history RENAME TO old_history_temp;

CREATE TABLE "history" (
    "id"            INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "datetime"      datetime NOT NULL,
    "data"          text,
    "userId"        INTEGER NOT NULL DEFAULT '0',
    "unix_timestamp" INTEGER DEFAULT (strftime('%s', 'now'))
);

INSERT INTO history (
    id, datetime, data, userId, unix_timestamp
)
SELECT
    id, datetime, data, userId,
    strftime('%s', datetime)
FROM old_history_temp;

DROP TABLE old_history_temp;

COMMIT;
