#ifndef LOGUPLOADER_H
#define LOGUPLOADER_H

#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QObject>
#include <QUrl>

#include "globals_ckvsoft.h"


class CKVSOFT_EXPORT LogUploader : public QObject {
    Q_OBJECT

public:
    explicit LogUploader(QObject *parent = nullptr);
    void uploadLog(const QString &logFilePath, const QString &deviceId, const QUrl &serverUrl);

signals:
    void uploadFinished(bool success, const QString &message);
    void uploadProgress(qint64 bytesSent, qint64 bytesTotal);

private slots:
    void onUploadFinished(QNetworkReply *reply);

private:
    QNetworkAccessManager networkManager;
    QString highlightLogFileAsString(const QString &plainTextPath);
    QString zipLogFile(const QString &logPath);
};

#endif // LOGUPLOADER_H
