/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2025 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#include "qrkgastroselector.h"
#include "database.h"
#include "qrkgastromanagers/qrkgastrotablemanager.h"
#include "reports.h"
#include "ui_qrkgastroselector.h"

#include <QDebug>
#include <QSqlDatabase>


QRKGastroSelector::QRKGastroSelector(QWidget *parent)
    : QWidget(parent)
    , ui(new Ui::QRKGastroSelector)
{
    ui->setupUi(this);
    connect(ui->exitButton, &QPushButton::clicked, this, &QRKGastroSelector::cancelGastroButton_clicked);
    connect(ui->quickButtons, &QrkRoomTableButtons::tableOrder, this, &QRKGastroSelector::tableOrder);
    connect(ui->managerButton, &QPushButton::clicked, this, &QRKGastroSelector::manager);
    connect(ui->controllPushButton, &QPushButton::clicked, this, &QRKGastroSelector::createCheckReceipt);
}

QRKGastroSelector::~QRKGastroSelector()
{
    delete ui;
}

DragPushButton *QRKGastroSelector::getTableButton(int id)
{
    return ui->quickButtons->getTableButton(id);
}

void QRKGastroSelector::manager()
{
    QRKGastroTableManager tableManager(this);
    if (tableManager.exec() == QRKGastroTableManager::Rejected)
        refresh();
    else
        ui->quickButtons->refresh();
}

void QRKGastroSelector::refresh()
{

    if (getTableCount() == 0) manager();

    ui->quickButtons->refresh();
    // Table 0 for DirectPay
    // emit tableOrder(0);
}

int QRKGastroSelector::getTableCount()
{
    QSqlDatabase dbc = Database::database();
    CSqlQuery query(dbc, Q_FUNC_INFO);
    query.exec("SELECT count(id) AS count FROM tables");
    if (query.next()) return query.value("count").toInt();

    return 0;
}

#include "qrkprogress.h"
#include "qrktimedmessagebox.h"
void QRKGastroSelector::createCheckReceipt(bool)
{

    QRKProgress waitBar;
    waitBar.setText(tr("Beleg wird erstellt."));
    waitBar.setWaitMode();
    waitBar.show();

    qApp->processEvents();

    Reports rep;
    bool ret = rep.checkEOAny();
    if (!ret) {
        return;
    }

    ReceiptItemModel receipt;
    if (receipt.createNullReceipt(CONTROL_RECEIPT)) {

        QrkTimedMessageBox messageBox(10, QMessageBox::Information, tr("Drucker"),
            tr("Kontrollbeleg wurde gedruckt. Nächster Vorgang wird gestartet."),
            QMessageBox::Yes | QMessageBox::Default);

        messageBox.setDefaultButton(QMessageBox::Yes);
        messageBox.setButtonText(QMessageBox::Yes, tr("OK"));
        messageBox.exec();
    } else {
        qCritical() << "Function Name: " << Q_FUNC_INFO << " Error: can't create CheckReceipt";
    }
}
