BEGIN TRANSACTION;

CREATE TEMPORARY TABLE `users_backup` (
        `ID`	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
        `username`	TEXT NOT NULL UNIQUE,
        `displayname`	TEXT NOT NULL,
        `password`	TEXT NOT NULL,
        `value`	INTEGER NOT NULL DEFAULT 0,
        `gender`	INTEGER NOT NULL DEFAULT 0,
        `avatar`	TEXT,
        `addDate`	datetime NOT NULL
);

INSERT INTO `users_backup` SELECT `ID`,`username`,`displayname`,`password`, `value`, `gender`, `avatar`, `addDate` FROM `users`;
DROP TABLE `users`;

CREATE TABLE `users` (
        `ID`	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
        `username`	TEXT NOT NULL UNIQUE,
        `displayname`	TEXT NOT NULL,
        `password`	TEXT NOT NULL,
        `value`	INTEGER NOT NULL DEFAULT 0,
        `gender`	INTEGER NOT NULL DEFAULT 0,
        `avatar`	TEXT,
        `acskey`	TEXT UNIQUE,
        `addDate`	datetime NOT NULL
);

INSERT INTO `users` SELECT `ID`,`username`,`displayname`,`password`, `value`, `gender`, `avatar`, NULL, `addDate` FROM `users_backup`;
DROP TABLE `users_backup`;

CREATE TEMPORARY TABLE `groups_backup` (
        `id`	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
        `name`	text NOT NULL,
        `color`	text DEFAULT '',
        `printerid`	INTEGER DEFAULT NULL,
        `image`	text DEFAULT '',
        `visible`	tinyint(1) NOT NULL DEFAULT 1,
        `categoryId`	INTEGER NOT NULL DEFAULT 1,
        `sortorder`	INTEGER NOT NULL DEFAULT 0,
        CONSTRAINT `categoryId` FOREIGN KEY(`categoryId`) REFERENCES `categories`(`id`)
);
INSERT INTO `groups_backup` SELECT `id`,`name`,`color`,`printerid`, `image`, `visible`, `categoryId`, `sortorder` FROM `groups`;
DROP TABLE `groups`;

CREATE TABLE `groups` (
        `id`	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
        `name`	text NOT NULL,
        `color`	text DEFAULT '',
        `printerid`	INTEGER DEFAULT NULL,
        `image`	text DEFAULT '',
        `tax`	NUMERIC,
        `visible`	tinyint(1) NOT NULL DEFAULT 1,
        `categoryId`	INTEGER NOT NULL DEFAULT 1,
        `sortorder`	INTEGER NOT NULL DEFAULT 0,
        CONSTRAINT `categoryId` FOREIGN KEY(`categoryId`) REFERENCES `categories`(`id`)
);
INSERT INTO `groups` SELECT `id`,`name`,`color`,`printerid`, `image`, NULL, `visible`, `categoryId`, `sortorder` FROM `groups_backup`;
DROP TABLE `groups_backup`;

COMMIT;
