SET FOREIGN_KEY_CHECKS=0;
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;

DROP TABLE `coupon`;

CREATE TABLE `coupons` (
  `id` int(11) NOT NULL,
  `timestamp` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `code` varchar(255) NOT NULL,
  `type` int(11) NOT NULL,
  `customer` int(8) NOT NULL,
  `gross` int(11) NOT NULL,
  `credit` int(11) NOT NULL,
  `tax` int(11) NOT NULL,
  `storno` int(1) NOT NULL DEFAULT 0,
  `stornotimestamp` datetime,
  `deleted` int(1) NOT NULL DEFAULT 0,
  `reference` varchar(255) NOT NULL,
  `checksum` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `userid` int(11) NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

ALTER TABLE `coupons` ADD PRIMARY KEY (`id`);
ALTER TABLE `coupons` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

CREATE TABLE coupon_redemptions (
    id INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
    coupon_id INT,
    redemption_date TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    redemption_amount INT,
    FOREIGN KEY(coupon_id) REFERENCES coupons(id)
);

SET FOREIGN_KEY_CHECKS=1;
COMMIT;
