#ifndef REGISTRATIONTAB_H
#define REGISTRATIONTAB_H

#include "../verification.h"
#include "../widget.h"

#include "../globals_ckvsoft.h"

#include <QJsonObject>

class QLabel;
class QCheckBox;
class PushButton;

class CKVSOFT_EXPORT RegistrationTab : public Widget {
    Q_OBJECT
public:
    RegistrationTab(const QString &appname, bool showActivateMessageBox = true, QWidget *parent = Q_NULLPTR);
    bool isValid(int &days);
    void setAlternateWebJsonData(QJsonObject jsonObjectData);
    void setShowActivateMessageBox(bool testing = true);
    void callWeb(bool renew = false);
    void callWebRenew();
    static bool isActive(const QString &name);
    static bool isActive(const QString &name, QString &strValue);
    static void setActive(const QString &name);
    static void setActive(const QString &name, QString &strValue);

private:
    QJsonObject loadLicense();
    Verification *m_verification = Q_NULLPTR;
    void saveLicense();
    void loadLicenseFromFile();
    void loadLicenseFromServer();
    void Verify();
    void checkBoxChecked(bool checked);
    void activateMessageBox();
    int getDemoDays(int valid);

    QString m_name = "QRK-PRO";
    QString m_alternatewebjsondata = "";
    QJsonObject m_license;
    bool m_isValid = false;
    bool m_showActivateMessageBox = true;

    QCheckBox *m_activateCheckBox;
    PushButton *m_webBuyPushButton;
    PushButton *m_webRenewPushButton;
    QLabel *m_serialnumber;
    QLabel *m_nameLabel;
    QLabel *m_expirydate;
    QLabel *m_signature;
    QLabel *m_validto;
    QLabel *m_textlabel;
    int m_demodays = -1;
    QString m_serial = 0;
};

#endif // REGISTRATIONTAB_H
