/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2024 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#ifndef ABSTRACTDATABASE_H
#define ABSTRACTDATABASE_H

#include "globals_ckvsoft.h"
#include <QObject>

class CSqlQuery;
class QSqlDatabase;

class CKVSOFT_EXPORT AbstractDataBase : public QObject {
    Q_OBJECT
public:
    AbstractDataBase(QObject *parent = Q_NULLPTR);
    ~AbstractDataBase();

    bool open(bool dbSelect, const QString &defaultdbtype = "QSQLITE", QString TESTFILE = QString());

    static bool isSqlCipher(const QString &filePath);
    static void insert2globals(const QString &name, const QVariant &value, const QVariant &strValue);
    static int select_globals(const QString &name, QVariant &value, QString &strValue, QString addWhere = "");
    static bool select_globals(const QString &name, QMap<QString, QVariant> &values, QString addWhere = "");
    static void delete_globals(const QString &name, const QString &where = "");
    static QString updateGlobals(const QString &name, QString defaultvalue, QString defaultStrValue);
    static QSqlDatabase database(const QString &connectionname = "CN");
    static bool exists(const QString &name);
    static bool exists(const QString &type, const int &id, const QString &fieldname = "id");
    static bool exists(const QString &type, const QString &name, const QString &fieldname);
    static QString getLastExecutedQuery(const CSqlQuery &query);
    static QJsonObject getConnectionDefinition();
    static QString getBaseDriver(const QSqlDatabase &db);

protected:
    static void reopen();
    virtual bool doDatabaseStuff(QSqlDatabase &currentConnection, bool &database_exists) = 0;
    static QString getDatabaseType();
    static int getCcurrentSchemaVersion();
};

extern QMap<QString, QString> globalStringValues;

#endif // ABSTRACTDATABASE_H
