#ifndef BACKUPWORKER_H
#define BACKUPWORKER_H

#include "qrkcore_global.h"

#include <QObject>
#include <QRunnable>

class QRK_EXPORT BackupWorker : public QObject, public QRunnable {
    Q_OBJECT

public:
    explicit BackupWorker(const QStringList &fullpathFilelist, const QString &backupDir, const QString &tempname,
        const QString &confname);
    ~BackupWorker();

    void run() override;
    static bool removeDir(const QString &dirName);

signals:
    void finishedCopyFiles();

private:
    void exportTables(const QString &backupDir, const QString &configName, QString &filename);
    void removeOldestFiles();
    QString getCreateTable(const QString &tablename);
    bool copyDatabaseFiles(const QStringList &filePaths, const QString &destinationDir, const QString &tempname);

    QStringList m_fullpathFilelist;
    QString m_backupDir;
    QString m_tempname;
    QString m_confname;
};

#endif // BACKUPWORKER_H
