#include "csqlquery.h"

#include <QApplication>
#include <QDebug>
#include <QMapIterator>
#include <QSqlError>

CSqlQuery::CSqlQuery(const QSqlDatabase &db, const QString &pretty_function)
    : QSqlQuery(db)
    , m_pretty_funktion(pretty_function)
{
}

CSqlQuery::CSqlQuery()
    : QSqlQuery()
{
}


bool CSqlQuery::exec()
{
    bool ok = QSqlQuery::exec();
    bool debugSql = qApp->property("debugSql").toBool();

    if (!ok && m_show_error) {
        if (m_is_critical) {
            qCritical() << "Function Name: " << m_pretty_funktion << " Error: " << lastError().text();
            qCritical() << "Function Name: " << m_pretty_funktion << " Query: " << getLastExecutedQuery();
        } else {
            qWarning() << "Function Name: " << m_pretty_funktion << " Error: " << lastError().text();
            qWarning() << "Function Name: " << m_pretty_funktion << " Query: " << getLastExecutedQuery();
        }
    } else if (debugSql) {
        qDebug() << "Function Name: " << m_pretty_funktion << " Query: " << getLastExecutedQuery();
    }
    m_show_error = true;
    m_is_critical = false;
    return ok;
}

bool CSqlQuery::exec(const QString &queryStr)
{
    prepare(queryStr);
    return CSqlQuery::exec();
}

QString CSqlQuery::getLastExecutedQuery() const
{
    QString str = lastQuery();
    QMapIterator<QString, QVariant> it(boundValues());
    it.toBack();

    while (it.hasPrevious()) {
        it.previous();
        str.replace(it.key(), it.value().toString());
    }

    return str;
}

void CSqlQuery::setShowError(bool show)
{
    m_show_error = show;
}
void CSqlQuery::setCriticalError(bool isCritical)
{
    m_is_critical = isCritical;
}
