#include "size.h"

#include <QString>
#include <QStringList>

Size::Size(int w, int h)
    : QString(QString("%1,%2").arg(w).arg(h))
{
    m_size = QString("%1,%2").arg(w).arg(h);
}

Size::Size(QString sizeString)
    : QString(sizeString)
{
    m_size = sizeString;
}

Size::Size(QSize size)
    : QString(QString("%1,%2").arg(size.width()).arg(size.height()))
{
    m_size = QString("%1,%2").arg(size.width()).arg(size.height());
}

QSize Size::toSize()
{
    QStringList list = m_size.split(",");
    return QSize(list.first().toInt(), list.last().toInt());
}

QString Size::toString()
{
    return m_size;
}
