/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#ifndef COUPONDELEGATE_H
#define COUPONDELEGATE_H

#include <QStyledItemDelegate>

class CouponDelegate : public QStyledItemDelegate {
    Q_OBJECT

public:
    enum COUPON_COLUMN { CURRENCY = 0, CREDIT, TYPE, DELETED, DATETIME, CODE, TAX, CHECKSUM };

    explicit CouponDelegate(COUPON_COLUMN column, int extraColumn = -1, QObject *parent = Q_NULLPTR);
    virtual QString displayText(const QVariant &value, const QLocale &locale) const override;
    virtual void paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const override;

private:
    COUPON_COLUMN m_current_column;
    int m_extraColumn;
};

#endif // COUPONDELEGATE_H
