/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */
#ifndef PRIMESIGNCARDOS_53_H
#define PRIMESIGNCARDOS_53_H

#include "primesignsmartcard.h"

#include "globals_ckvsoft.h"

#define PRIMESIGN_OS53_CMD_PUT_HASH "\x00\x2A\x9E\x9A\x20" // + 32 byte SHA256

class CKVSOFT_EXPORT PrimeSignCARDOS_53 : public PrimeSignSmartCard {
public:
    PrimeSignCARDOS_53(QString device_name, bool shared = false);
    ~PrimeSignCARDOS_53();

    QString signReceipt(QString data) override;
    QString getCertificateSerial(bool hex = true) override;
    QString getCertificate(bool base64 = true) override;
    QString getCardType() override;
    QString getExpireInfo() override;
    QString getSVI() override
    {
        return "AT3";
    }
    bool verifyPin(bool &blocked) override;

protected:
    bool selectDF_QES();
    void getPrivateKey(unsigned char *pkey);

    ASignResponse signHash(const unsigned char hash[32]) override;
};

#endif // PRIME_SIGNCARDOS_53_H
