/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#ifndef CUSTOMTOOLBUTTON_H
#define CUSTOMTOOLBUTTON_H

#include "globals_ckvsoft.h"

#include <QProxyStyle>
#include <QToolButton>

class CKVSOFT_EXPORT CustomToolButton : public QToolButton {
    Q_OBJECT

public:
    explicit CustomToolButton(QWidget *parent = Q_NULLPTR);
    virtual void setMinimumSize(const QSize);

protected:
    virtual void initialize();
};

class CKVSOFT_EXPORT CenteredToolButtonStyle : public QProxyStyle {
    Q_OBJECT
public:
    CenteredToolButtonStyle(QToolButton *b, const QSize &sIcon);
    virtual void drawItemPixmap(QPainter *painter, const QRect &rect, int, const QPixmap &pixmap) const override
    {
        m_pic = pixmap;
        m_ny = rect.y();
        Draw(painter);
    }
    virtual void drawItemText(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled,
        const QString &text, QPalette::ColorRole textRole = QPalette::NoRole) const override;
    void Draw(QPainter *painter) const;
    const QToolButton *B;
    const QSize SICON;
    mutable QString m_s;
    mutable QPixmap m_pic;
    mutable QRect m_r;
    mutable int m_nf, m_ny;
    mutable bool m_bEnabled;
    mutable QPalette m_pal;
    mutable QPalette::ColorRole m_textRole;
};

#endif // CUSTOMTOOLBUTTON_H
