/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */
#ifndef WAITERLOCKACS_H
#define WAITERLOCKACS_H

#include "3rdparty/ckvsoft/rbac/acsinterface.h"
#include "3rdparty/ckvsoft/rbac/base_login.h"
#include "qrkcore_global.h"

class WaiterLock;

class QRK_EXPORT QrkWaiterLockACS : public ACSInterface {
    Q_OBJECT

public:
    QrkWaiterLockACS(QDialog *parent = Q_NULLPTR);

    int execute(int userid) override;
    QString getAcsKey() override;
    void setWaiterLock(WaiterLock *wl);

private:
    void OnChange();
    QString m_acskey;
    WaiterLock *m_waiterlock = Q_NULLPTR;
    int m_userid;
};

#endif // WAITERLOCKACS_H
