/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#include "comboboxdelegate.h"

#include <QApplication>
#include <QComboBox>

ComboBoxDelegate::ComboBoxDelegate(QList<QString> l, QObject *parent)
    : QItemDelegate(parent)
    , m_list(l)
{
}

QWidget *ComboBoxDelegate::createEditor(
    QWidget *parent, const QStyleOptionViewItem & /* option */, const QModelIndex & /* index */) const
{
    QComboBox *editor = new QComboBox(parent);
    for (int i = 0; i < m_list.size(); ++i) {
        editor->addItem(m_list.at(i));
    }

    connect(editor, static_cast<void (QComboBox::*)(int)>(&QComboBox::currentIndexChanged), this,
        &ComboBoxDelegate::commitAndCloseEditor);

    return editor;
}

void ComboBoxDelegate::setEditorData(QWidget *editor, const QModelIndex &index) const
{
    QComboBox *comboBox = static_cast<QComboBox *>(editor);
    QString value = index.data().value<QString>();
    comboBox->setCurrentIndex(comboBox->findText(value));
    // comboBox->showPopup();
}

void ComboBoxDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const
{
    QComboBox *comboBox = static_cast<QComboBox *>(editor);
    // model->setData(index, comboBox->currentIndex(), Qt::EditRole);
    model->setData(index, QVariant::fromValue(comboBox->currentText().trimmed()));
}

void ComboBoxDelegate::updateEditorGeometry(
    QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex & /* index */) const
{
    editor->setGeometry(option.rect);
}

void ComboBoxDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
{
    QStyleOptionViewItem myOption = option;
    myOption.displayAlignment = Qt::AlignRight | Qt::AlignVCenter;
    QString value = index.data().value<QString>();
    myOption.text = value;
    QItemDelegate::paint(painter, myOption, index);
    return;
}

void ComboBoxDelegate::commitAndCloseEditor()
{
    QComboBox *combo = static_cast<QComboBox *>(sender());
    emit commitData(combo);
    emit closeEditor(combo);
}
