/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */


#include "3rdparty/ckvsoft/RK/rk_signaturemodule.h"
#include "3rdparty/ckvsoft/RK/rk_signaturemodulefactory.h"
#include "3rdparty/ckvsoft/csqlquery.h"
#include "3rdparty/ckvsoft/databasemanager.h"
#include "3rdparty/ckvsoft/rbac/crypto.h"
#include "database.h"
#include "importtest.h"

#include <cryptopp/aes.h>
#include <cryptopp/filters.h>
#include <cryptopp/hex.h>
#include <cryptopp/modes.h>
#include <cryptopp/sha.h>

#include "qsqldatabase.h"

#include <QDebug>
#include <QDir>
#include <QMessageAuthenticationCode>
#include <QtTest/QTest>

class QRK : public QObject {
    Q_OBJECT

private slots:
    void crypto_make_key(void)
    {
        const SecureByteArray masterPassword = QString("7h15p455w0rd15m0r37h4n53cr37").toUtf8();
        SecureByteArray key;
        SecureByteArray iv;
        Crypto::makeKeyandIvFromPassword(masterPassword, key, iv);

        QVERIFY(key.size() == CryptoPP::AES::MAX_KEYLENGTH);
        QVERIFY(key.toBase64() == "yXoW7/KiUiO+KOeBmyKDEBQCXRkbBb/3c+xlU0SXBEM=");
        QVERIFY(iv.size() == CryptoPP::AES::BLOCKSIZE);
        QVERIFY(iv.toBase64() == "OVz9yELbX20s9iHogmDPWg==");
    }

    void crypto_uniqueid(void)
    {
        QString key1 = Crypto::getRealUniqueId();
        QString key2 = Crypto::getRealUniqueId();

        qDebug() << "key1: " << key1 << " key2: " << key2;
        QVERIFY(key1.compare(key2) != 0);
    }

    void base32_encode_decode(void)
    {
        QByteArray teststr = QString("Das ist ein Base32 encode Test").toUtf8();
        QByteArray encode = RKSignatureModule::base32_encode(teststr);
        QByteArray decode = RKSignatureModule::base32_decode(encode);
        QVERIFY(decode == teststr);
    }

    void encrypt_decrypt_TurnoverCounter(void)
    {
        const SecureByteArray masterPassword = QString("7h15p455w0rd15m0r37h4n53cr37").toUtf8();
        SecureByteArray key;
        SecureByteArray iv;
        Crypto::makeKeyandIvFromPassword(masterPassword, key, iv);
        QString concatenated = "concatenated";
        qlonglong turnoverCounter = -12345;
        RKSignatureModule *module = RKSignatureModuleFactory::createInstance("", true);
        QString encrypt = module->encryptTurnoverCounter(concatenated, turnoverCounter, key.toHex());
        QString decrypt = module->decryptTurnoverCounter(concatenated, encrypt, key.toHex());
        QVERIFY(turnoverCounter == decrypt.toLongLong());

        turnoverCounter = 34567;
        encrypt = module->encryptTurnoverCounter(concatenated, turnoverCounter, key.toHex());
        decrypt = module->decryptTurnoverCounter(concatenated, encrypt, key.toHex());
        QVERIFY(turnoverCounter == decrypt.toLongLong());

        delete module;
    }

    void datetime(void)
    {
        QTime timeFrom = QTime(04, 00, 0);
        QTime timeTo = QTime(21, 00, 0);
        QDateTime dtFrom = QDateTime::currentDateTime().addSecs(-QTime(0, 0, 0).secsTo(timeFrom));
        QDateTime dtTo = QDateTime::currentDateTime().addSecs(QTime(0, 0, 0).secsTo(timeTo));
        QDate date = QDate::currentDate();
        qDebug() << "timeFrom: " << timeFrom << " datetimeFrom: " << dtFrom << " datetimeFrom date: " << dtFrom.date()
                 << " date: " << date;
        qDebug() << "timeTo: " << timeTo << " datetimeTo: " << dtTo << " datetimeTo date: " << dtTo.date()
                 << " date: " << date;

        qDebug() << "!(type ==  PAYED_BY_REPORT_EOD) " << !(12 == 12) << " (type !=  PAYED_BY_REPORT_EOD) "
                 << (12 != 12);
        //            QVERIFY(dt.date() == date);
    }

    void urlencode(void)
    {
        QByteArray ba;
        ba = QUrl("Höfer & Co").toEncoded();
        qDebug() << "UrlEncode: " << ba;
        qDebug() << "UrlPercentEncode: " << QUrl::toPercentEncoding("Höfer & Co");
    }
    void database_cipher_available(void)
    {
        // Prüft, ob der Treiber im System registriert ist
        QVERIFY(QSqlDatabase::drivers().contains("QSQLCIPHER"));
    }

    void database_encryption_check(void)
    {
        qDebug() << Crypto::encrypt("QSQLCIPHER", SecureByteArray("Globals"));
        QString testDbPath = QDir::tempPath() + "/cipher_test.db";
        if (QFile::exists(testDbPath)) QFile::remove(testDbPath);

        {
            bool opened = Database().open(false, "QSQLCIPHER", testDbPath);
            QVERIFY(opened);

            // Nutze die Verbindung von Database
            QSqlDatabase dbc = Database::database();
            CSqlQuery q(dbc, Q_FUNC_INFO); // Q_FUNC_INFO für deinen Wrapper

            QVERIFY(q.exec("CREATE TABLE test_cipher (id INTEGER PRIMARY KEY, data TEXT);"));
            QVERIFY(q.exec("INSERT INTO test_cipher (data) VALUES ('geheim');"));
        }

        // Datenbank-Verbindung sauber trennen, bevor wir sie mit QSQLITE testen
        DatabaseManager::clear();

        // Gegentest: Mit normalem SQLite öffnen (ohne Key)
        QSqlDatabase dbNormal = QSqlDatabase::addDatabase("QSQLITE", "test_failure_conn");
        dbNormal.setDatabaseName(testDbPath);

        {
            QSqlDatabase dbNormal = QSqlDatabase::addDatabase("QSQLITE", "test_failure_conn");
            dbNormal.setDatabaseName(testDbPath);

            if (dbNormal.open()) {
                QSqlQuery qNormal(dbNormal);
                bool selectWorked = qNormal.exec("SELECT * FROM test_cipher;");
                QVERIFY(selectWorked == false);
            }
            dbNormal.close();
        }
        QSqlDatabase::removeDatabase("test_failure_conn");
        QFile::remove(testDbPath);
    }

    void database_full_import_test(void)
    {
        // Hier rufen wir deine importtest.cpp Logik auf
        ImportTest importTester;

        // QVERIFY sorgt dafür, dass der Test als "FAILED" markiert wird,
        // falls deine test() Funktion false zurückgibt.
        QVERIFY(importTester.test());
    }
};

// QTEST_GUILESS_MAIN(QRK)
QTEST_MAIN(QRK)
#include "test-main.moc"
