/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */

#include "coupon.h"
#include "3rdparty/profeatures/profeatures.h"
#include "coupondialog.h"
#include "couponredemption.h"
#include "couponsettingswidget.h"
#include "database.h"

#include <QDialog>
#include <QLabel>
#include <QVBoxLayout>

Coupon::Coupon(QObject *parent)
    : IndependentInterface()
{
    setParent(parent);
    m_root = new QDialog;
    m_custom = new QrkCustomDialog;
}

Coupon::~Coupon()
{
}

bool Coupon::process(QMap<QString, QVariant> &arguments)
{

    if (arguments.contains("whatever") && arguments.value("whatever").toInt() == 1)
        return CouponRedemption::update(arguments);

    CouponDialog dialog;
    if (isActivated()) {
        dialog.setWindowTitle(getPluginName());
        dialog.exec();
    } else {
        SettingsDialog()->exec();
    }

    return true;
}

QrkCustomDialog *Coupon::CustomDialog(ReceiptItemModel *model)
{
    QVBoxLayout *layout = new QVBoxLayout;

    CouponRedemption *cr = new CouponRedemption(model);
    layout->addWidget(cr);

    m_custom->setLayout(layout);
    // connect(cr, &CouponRedemption::close, m_custom, &QDialog::close);
    connect(m_custom, &QrkCustomDialog::valueChanged, cr, &CouponRedemption::setValue);
    connect(cr, &CouponRedemption::valueChanged, m_custom, &QrkCustomDialog::setValue);
    connect(cr, &CouponRedemption::cancel, m_custom, &QrkCustomDialog::close);
    connect(cr, &CouponRedemption::accepted, m_custom, &QrkCustomDialog::accept);

    return m_custom;
}

QDialog *Coupon::SettingsDialog()
{
    QVBoxLayout *layout = new QVBoxLayout;

    CouponSettingsWidget *sw = new CouponSettingsWidget;
    layout->addWidget(sw);

    m_root->setLayout(layout);
    connect(sw, &CouponSettingsWidget::saved, m_root, &QDialog::close);
    connect(sw, &CouponSettingsWidget::rejected, m_root, &QDialog::reject);
    return m_root;
}

bool Coupon::isActivated()
{
    QVariant value;
    QString strValue;

    Database::select_globals("coupon_active", value, strValue);
    return value.toBool() && ProFeatures::isValid();
}
