/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */
#ifndef PRIMESIGNONLINE_H
#define PRIMESIGNONLINE_H

#include "rk_signatureonline.h"
#include <QtNetwork/QtNetwork>

#include "globals_ckvsoft.h"

class CKVSOFT_EXPORT PrimeSignOnline : public RKSignatureOnline {
public:
    PrimeSignOnline(QString connectionString);
    ~PrimeSignOnline();

    QString signReceipt(QString data) override;
    QString getCertificateSerial(bool hex = true) override;
    QString getCertificate(bool base64 = true) override;
    bool selectApplication() override;
    QString getCardType() override;
    QString getExpireInfo() override
    {
        return QString();
    }
    QString getSVI() override
    {
        return "AT3";
    }

protected:
    bool doRequest(QNetworkRequest &req, QJsonObject &obj);
    QByteArray getRaw(const QUrl &url);
    QString extractBase64FromPEM(const QByteArray &pem);
    bool login();
    bool logout();

private:
    void setAuthHeader(QNetworkRequest &req);

    QNetworkAccessManager *m_manager = nullptr;
    QString m_userid;
    QString m_sharedsecret;
    QString m_url;
    QString m_keyId;
    QString m_certificateSerial;
    QString m_certificateSerialHex;
    QString m_alg;
};

#endif // PRIMESIGNONLINE_H
