/*
 * This file is part of QRK - Qt Registrier Kasse
 *
 * Copyright (C) 2015-2026 Christian Kvasny <chris@ckvsoft.at>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Button Design, and Idea for the Layout are lean out from LillePOS, Copyright
 * 2010, Martin Koller, kollix@aon.at
 *
 */
#ifndef CSQLQUERY_H
#    define CSQLQUERY_H

#    include "globals_ckvsoft.h"

#    include <QSqlDatabase>
#    include <QSqlQuery>
#    include <QString>
#    undef QSQLQUERY_DEPRECATED

class CKVSOFT_EXPORT CSqlQuery : public QSqlQuery {
public:
    explicit CSqlQuery(const QSqlDatabase &db, const QString &pretty_funktion);
    CSqlQuery();

    bool exec();
    bool exec(const QString &queryStr);
    QString getLastExecutedQuery() const;
    QString m_pretty_funktion;
    void setShowError(bool show);
    void setCriticalError(bool show);

private:
    bool m_show_error = true;
    bool m_is_critical = false;
};

#endif // CSQLQUERY_H
#define QSQLQUERY_DEPRECATED [[deprecated(QSQLQUERY_ERROR)]]
